<?php
require_once('utility.php');
function get_esxi_vm_state($argv) {
	/* check number of arguments */
	if(count($argv) != 4) {
		echo "Usage: get_esxi_vm_state ESXI_HOST ESXI_USERNAME ESXI_PASSWORD VM_PATH\n";
		exit(1);
	}

	/* fetch arguments */
	$esxi_host = escapeshellarg($argv[0]);
	$esxi_username = escapeshellarg($argv[1]);
	$esxi_password = escapeshellarg($argv[2]);
	$vm_path = escapeshellarg($argv[3]);

	/* execute main function */
	unset($result_array);
    $portNumber = getEsxiPort($esxi_host);
	exec("vmware-cmd --server $esxi_host --portnumber $portNumber --username $esxi_username --password $esxi_password $vm_path getstate 2>&1", $result_array, $return_value);
	foreach($result_array as $line) {
		echo $line . "\n";
	}
	exit($return_value);
}

